<?php
// ====================================================================
// ⚙️ CONFIGURATION (CREDENTIALS & SETTINGS)
// ====================================================================

define('BOT_TOKEN', '8298093995:AAHidKymXh9K9UKelSktfS4vuaGgU6E_lis');
define('GEMINI_API_KEY', 'AIzaSyD8_h4lTgh21NQmL3ux09l5uOjgCztXkio');
define('ADMIN_IDS', [8471621112, 860608903]); // Sirf ye log Broadcast/Post kar payenge

define('API_URL', 'https://api.telegram.org/bot'.BOT_TOKEN.'/');

// Data Folders
define('DATA_DIR', 'bot_data/');
if (!is_dir(DATA_DIR)) mkdir(DATA_DIR); 
define('LINKS_DIR', DATA_DIR . 'links/');
if (!is_dir(LINKS_DIR)) mkdir(LINKS_DIR);
define('USERS_FILE', DATA_DIR . 'users.json');
define('BLOCKED_FILE', DATA_DIR . 'blocked.json');

// ====================================================================
// 🧠 ADVANCED GEMINI AI (No Repetition, Full Creativity)
// ====================================================================
class GeminiAIChat {
    public function getAIResponse($user_message, $user_name) {
        $url = "https://generativelanguage.googleapis.com/v1beta/models/gemini-pro:generateContent?key=" . GEMINI_API_KEY;
        
        // 🔥 PROMPT ENGINEERING: Isse AI repetitive nahi hoga
        $system_prompt = "You are '𝄟͢🦋⃟ᴹɪˢˢ√PRIYA🔥⃝🕊️ai', a highly intelligent, savage, and funny AI on Telegram. 
        User: {$user_name}.
        Language: Hinglish (Hindi + English Mix).
        
        INSTRUCTIONS:
        1. NEVER repeat the same sentence twice. Be creative.
        2. You can talk about ANY topic (Movies, Life, Coding, Roast, Love).
        3. If user says 'Hi' or 'Hello', give a different funny welcome each time.
        4. Use Emojis heavily.
        5. If user asks for files, tell them to click the '📁 File Search' button.
        6. Keep replies under 100 words unless asked for a long story.";

        $data = [
            'contents' => [
                ['parts' => [['text' => $system_prompt . "\n\nUser said: " . $user_message]]]
            ],
            'generationConfig' => [
                'maxOutputTokens' => 800,
                'temperature' => 1.0,     // 1.0 means Maximum Randomness (No repetition)
                'topP' => 0.95
            ]
        ];
        
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($ch);
        curl_close($ch);
        
        if ($response) {
            $result = json_decode($response, true);
            if (isset($result['candidates'][0]['content']['parts'][0]['text'])) {
                return $result['candidates'][0]['content']['parts'][0]['text'];
            }
        }
        // Fallback agar AI fail ho (Bahut kam chance hai)
        return "Arre yaar dimag hang ho gaya mera! Wapis bolna? 😵‍💫";
    }
}

// ====================================================================
// 🛠️ UTILITY FUNCTIONS (Buttons & Actions)
// ====================================================================

// Send Message with Buttons Support
function sendMessage($chat_id, $text, $keyboard = null) {
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'Markdown'
    ];
    
    if ($keyboard) {
        $data['reply_markup'] = json_encode($keyboard);
    }

    $ch = curl_init(API_URL . "sendMessage");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_exec($ch);
    curl_close($ch);
}

// Typing Action (Dikhane ke liye ki Bot likh raha hai)
function sendAction($chat_id, $action = 'typing') {
    $url = API_URL . "sendChatAction?chat_id=$chat_id&action=$action";
    file_get_contents($url);
}

// Main Menu Buttons (Jo hamesha dikhenge)
function getMainMenu() {
    return [
        'keyboard' => [
            [['text' => '📁 File Search'], ['text' => '🎥 Videos']],
            [['text' => '🆘 Help'], ['text' => '👨‍💻 Developer']],
            [['text' => '🤖 AI Chat Mode']]
        ],
        'resize_keyboard' => true,
        'one_time_keyboard' => false
    ];
}

function isAdmin($user_id) {
    return in_array($user_id, ADMIN_IDS);
}

function saveUser($user_id) {
    $users = file_exists(USERS_FILE) ? json_decode(file_get_contents(USERS_FILE), true) : [];
    if (!in_array($user_id, $users)) {
        $users[] = $user_id;
        file_put_contents(USERS_FILE, json_encode($users));
    }
}

function isBlocked($user_id) {
    $blocked = file_exists(BLOCKED_FILE) ? json_decode(file_get_contents(BLOCKED_FILE), true) : [];
    return in_array($user_id, $blocked);
}

// ====================================================================
// 🎮 MAIN BOT LOGIC (Buttons + Commands + AI)
// ====================================================================

function processUpdate($update) {
    if (!isset($update['message'])) return;
    
    $message = $update['message'];
    $chat_id = $message['chat']['id'];
    $user_id = $message['from']['id'];
    $text = $message['text'] ?? '';
    $name = $message['from']['first_name'] ?? 'Dost';

    saveUser($chat_id);

    if (isBlocked($user_id)) return;

    // 1. HANDLE BUTTON CLICKS (Text ko button se match karega)
    
    if ($text == '/start' || $text == '🆘 Help') {
        $msg = "👋 **Welcome $name!**\n\nI'm 𝄟͢🦋⃟ᴹɪˢˢ√PRIYA🔥⃝🕊️! 😎\n\n👇 **Neeche Buttons use karo:**\n\n• **Files:** Movies/Software dhoondo\n• **AI Chat:** Mujhse kuch bhi baatein karo\n• **Admin:** Sirf admin commands use kar sakta hai.";
        sendMessage($chat_id, $msg, getMainMenu());
        return;
    }

    if ($text == '📁 File Search' || $text == '🎥 Videos') {
        sendMessage($chat_id, "🔍 **File Search Mode**\n\nKoi bhi keyword likho search karne ke liye.\nExample: `/search avengers` ya `/search windows`", getMainMenu());
        return;
    }

    if ($text == '👨‍💻 Developer') {
        sendMessage($chat_id, "👨‍💻 **Developer Info:**\n\nOwner: Admin 𝄟͢🦋⃟ᴹɪˢˢ√PRIYA🔥⃝🕊️\nPowered by: @Texuscheat", getMainMenu());
        return;
    }

    if ($text == '🤖 AI Chat Mode') {
        sendMessage($chat_id, "💬 **AI Mode On!**\n\nBas type karna shuru karo, main har baat ka jawab dunga! (Masti, Gyaan, Roast - Sab chalega)", getMainMenu());
        return;
    }

    // 2. ADMIN COMMANDS (Hidden)
    
    if (isAdmin($user_id)) {
        if (strpos($text, '/broadcast ') === 0) {
            $msg = substr($text, 11);
            $users = json_decode(file_get_contents(USERS_FILE), true);
            foreach ($users as $uid) sendMessage($uid, "📢 **Broadcast:**\n$msg");
            sendMessage($chat_id, "✅ Broadcast sent!");
            return;
        }
        if (strpos($text, '/post ') === 0) {
            $parts = explode(' ', $text, 3);
            if(count($parts) >= 3) {
                sendMessage($parts[1], $parts[2]); // Channel ID, Message
                sendMessage($chat_id, "✅ Posted to channel.");
            }
            return;
        }
        if (strpos($text, '/add ') === 0) {
            $parts = explode(' ', $text, 3);
            if(count($parts) >= 3) {
                $file = LINKS_DIR . strtolower($parts[1]) . '.json';
                $links = file_exists($file) ? json_decode(file_get_contents($file), true) : [];
                $links[] = $parts[2];
                file_put_contents($file, json_encode($links));
                sendMessage($chat_id, "✅ Added link to {$parts[1]}");
            }
            return;
        }
        // Admin Files Check
        if ($text == '/adminfiles') {
            $files = glob(LINKS_DIR . "*.json");
            $report = "📂 **Database Status:**\n";
            foreach($files as $f) $report .= basename($f) . ": " . count(json_decode(file_get_contents($f))) . " links\n";
            sendMessage($chat_id, $report);
            return;
        }
    }

    // 3. SEARCH LOGIC
    if (strpos($text, '/search ') === 0) {
        $keyword = strtolower(trim(substr($text, 8)));
        $results = "";
        $found = false;
        foreach (glob(LINKS_DIR . "*.json") as $file) {
            $data = json_decode(file_get_contents($file), true);
            foreach ($data as $link) {
                if (stripos($link, $keyword) !== false) {
                    $results .= "🔗 $link\n";
                    $found = true;
                }
            }
        }
        if ($found) sendMessage($chat_id, "🔎 **Results for '$keyword':**\n$results", getMainMenu());
        else sendMessage($chat_id, "❌ '$keyword' nahi mila bhai. Admin ko bolo add karein.", getMainMenu());
        return;
    }

    // 4. AI CHAT (Agar upar ka koi command nahi tha)
    
    // Typing action bhejo taaki real lage
    sendAction($chat_id, 'typing');
    
    $ai = new GeminiAIChat();
    $reply = $ai->getAIResponse($text, $name);
    
    // AI ka reply bhejo (Buttons ke saath)
    sendMessage($chat_id, $reply, getMainMenu());
}

// Receive Webhook Data
$content = file_get_contents("php://input");
$update = json_decode($content, true);
if ($update) processUpdate($update);

// Auto Webhook Setup
if (!file_exists('webhook.lock')) {
    $url = "https://" . $_SERVER['HTTP_HOST'] . $_SERVER['SCRIPT_NAME'];
    file_get_contents(API_URL . "setWebhook?url=" . $url);
    file_put_contents('webhook.lock', 'SET');
}
?>

<!-- STATUS PANEL -->
<!DOCTYPE html>
<head><title>Bot Panel</title></head>
<body style="background:#222;color:#fff;font-family:sans-serif;padding:20px;">
    <h2>🤖 Ultra AI Bot Panel</h2>
    <p>Webhook: ✅ Active</p>
    <p>Status: ✅ Running</p>
    <p>Admin Mode: ✅ Protected</p>
</body>
</html>